    /* Test problem: Below are the details of the included test problem. 

       Dimension: n = 9

         min 0.5 * x'Hx + c'x   s.t.   lo <= x <= hi, bl <= Ax <= bu

       where the cost function and constraints are taken from the CUTEst
       test problem DUALC1. For this problem, the Hessian H and the
       constraint matrix A are both dense, H is 9 by 9 and A is 215 by 9 */

#include <stdio.h>
#include <stdlib.h>
#include "pasa.h"

/* main function */
int main (void /*int argc, char **argv*/)
{
    FILE *A_file;
    PASAdata  *pasadata ; 
    PASAINT  i, temp ;
    
    /* Initialize the pasadata structure for storing the problem description.
       pasa_setup returns a pointer to a data structure where
       all parameter values are set to default values. */
    printf ("Initializing PASAdata structure.\n") ;
    pasadata = pasa_setup () ;
    if ( pasadata == NULL )
    {
        printf ("pasa_setup ran out of memory\n") ;
    }
    else
    {
        printf ("Successfully initialized PASAdata structure.\n") ;
    }

    /* The A matrix is dense, so it is input as a packed array. Both
       the row and column dimension are needed. */
    PASAINT ncol = pasadata->ncol = 9 ;
    PASAINT nrow = pasadata->nrow = 215 ;

    PASAINT sF = sizeof (PASAFLOAT) ;
    /* allocate space for the A matrix, it will be read by rows */
    PASAFLOAT *A = pasadata->A_by_rows = (PASAFLOAT *) malloc (nrow*ncol*sF) ;

    /* Open file containing data for constraint matrix A */
    A_file = fopen("demoQP_A.csv", "r") ;

    /* Check that the file was successfully opened */
    if (A_file == NULL)
    {
        /* File unsucccessfully accessed; Print error message */
        printf("Error loading data for constraint matrix A in demoQP.c.\n") ;
        /* Exit program */
        return (0) ;
    }
    /* * Loop through file and store values in array A */
    for (i = 0; i < nrow*ncol; i++)
    {
        temp = fscanf(A_file, "%le,", &A[i] ) ;
        /* Check that number of inputs read by fscanf is exactly 1 */
        if (temp != 1)
        {
            /* Error reading constraint matrix data */
            printf("Error reading data with fscanf for constraint matrix "
                   "A in demoQP.c.\n") ;
            /* Exit program */
            return (0) ;
        }
    }
    /* Close file containing values of constraint matrix A */
    fclose(A_file) ;

/* Hessian of QP objective stored by rows */
PASAFLOAT Hess [] = {  
    14882,    4496,    5258,    5204,   8407,   8092,  -42247, -116455,   51785,
     4496,   65963,  -17504,  -17864, -15854, -14818, -100219, -101506,   25690,
     5258,  -17504,   17582,   17642,  15837,  17186,   27045,  -53251,   26765,
     5204,  -17864,   17642,   17738,  15435,  16898,   26625,  -56011,   27419,
     8407,  -15854,   15837,   15435,  35281,  48397,   48427,   29317,   12170,
     8092,  -14818,   17186,   16898,  48397,  93500,    5386,  -92344,  112416,
   -42247, -100219,   27045,   26625,  48427,   5386, 1027780, 1744550, -963140,
  -116455, -101506,  -53251,  -56011,  29317, -92344, 1744550, 5200790,-2306620,
    51785,   25690,   26765,   27419,  12170, 112416, -963140,-2306620, 1390020
} ;

    pasadata->Hdense = Hess ;

    /* If the Hessian was a sparse matrix, not a dense matrix, then it could
       be input using either the triples format or the standard sparse
       matrix format. See PASAdata_struct in PASA/Include/pasa.h. */

    /* linear term for the cost function must be provided for quadratic mode */
    PASAFLOAT c [] = {0, 5765.7624165, 3753.0154856, 3753.4216509,
          11880.124847, 29548.987048, 423163.83666, 3369558.8652, 439695.6796} ;
    pasadata->c = c ;

    /* Input the lower and upper bounds for A*x */
    PASAFLOAT *bl = pasadata->bl = (PASAFLOAT *) malloc (nrow*sF) ;
    /* Initialize all values of bl to zero */
    pasa_initx (bl, (PASAFLOAT) 0, nrow) ;
    /* Set 0th and 213th elements to 1 and -PASAINF, respectively */
    bl[0] = 1 ;
    bl[213] = -PASAINF ;

    PASAFLOAT *bu = pasadata->bu = (PASAFLOAT *) malloc (nrow*sF) ;
    /* Initialize all values of bu to PASAINF */
    pasa_initx (bu, PASAINF, nrow) ;
    /* Set 0th and 213th elements to 1 and 0, respectively */
    bu[0] = 1 ;
    bu[213] = 0 ;

    /* The ncol lower bounds for x are all zero. */
    PASAFLOAT *lo = pasadata->lo = (PASAFLOAT *) malloc (ncol*sF) ;
    pasa_initx (lo, (PASAFLOAT) 0, ncol) ;

    /* The ncol upper bounds for x are all one. */
    PASAFLOAT *hi = pasadata->hi = (PASAFLOAT *) malloc (ncol*sF) ;
    pasa_initx (hi, (PASAFLOAT) 1, ncol) ;

    /* A starting guess for the solution x would be stored in pasadata->x.
       Be sure to first malloc the memory:
       pasadata->x = (PASAFLOAT *) malloc (ncol*sizeof (PASAFLOAT)) ;
       We do not give a starting guess, in which case pasa employs x = 0. */

    /* ---------------------- Customizing parameters ------------------------ */
    /* When pasa_setup() is called, all pasa parameters are set to their
       default values, which means that there is no printing. Let's print
       the statistics for the pasa run.  */
    pasadata->Parms->pasa->PrintStat = TRUE ;

    /* call pasa to solve the problem. */
    pasa (pasadata) ; 

    /* By default, the run status is printed. The printing of the run status
       can be turned off by setting pasadata->Parms->pasa->PrintStatus = FALSE ;
       The status is also returned by pasa: int status = pasa(pasadata) ;
       If status = 0, then the run was successful.  After a run, the status
       is print using pasa_print_status (pasadata) ; */

    /* Print the solution */
    pasa_printx (pasadata->x, pasadata->ncol, "solution") ;

    /* free all memory malloc'd by the user */
    pasa_free (A) ;
    pasa_free (bl) ;
    pasa_free (bu) ;
    pasa_free (lo) ;
    pasa_free (hi) ;

    /* use pasa_terminate to free the pasadata structure and all the memory
       that was malloc'd for the pasadata structure. */
    pasa_terminate (&pasadata) ;

    /* exit the program */
    return (0) ;
}
