function demoNAP
%% -------------------------- Problem Details -------------------------- %%
%   This is a demo for showing how to set up and solve a knapsack problem
%   using PASA. The problem is
%   
%              min             0.5 x'*diag([1 2 3])*x + c'*x
%              s.t      -1 <= x <= 1, -1 <= A*x <= 1 
%
%   where A = [1 0 -1] and c = [1 -2  1].

%% ---------------- User defined parameter values for pasa ------------- %%
    % See pasa_default inside SuiteOPT/PASA/Source/pasa.c for a description
    % of the parameters. A printout of the parameters for pasa is generated
    % by the statement: pasadata.pasa.PrintParm = 1 ; by default,
    % PrintParm = 0 and no parameters are printed. Detailed statistics
    % for pasa is generated by the statement: pasadata.pasa.PrintStat = 1 ;
    % Again, the default is PrintStat = 0.
    pasadata.pasa.PrintStat = 1 ;

    % --------------------- Set up the pasa structure -------------------- %
    % If pasadata.lo is omitted, it is assumed to be -infinity. Similarly, if
    % pasadata.hi is omitted, it is assumed to be +infinity.
    % The bounds bl and bu are treated in a similar fashion.
    pasadata.a  = [1 0 -1] ;     % linear constraint matrix
    pasadata.d  = [1 2 3] ;      % quadratic cost vector
    pasadata.bl = [-1] ;         % lower bounds for Ax
    pasadata.bu = [1] ;          % upper bounds for Ax
    pasadata.lo = [-1 -1 -1] ;   % lower bound for x
    pasadata.hi = [ 1  1  1] ;   % upper bound for x
    pasadata.c  = [1 -2  1] ;    % linear term in objective 

    % -------------------------- Call pasa -------------------------- % 
    [x, stats, lambda] = pasa (pasadata) ;
%

%% ------------------------ Print pasa outputs ------------------------- %%
    % The numerical values for the statistics are stored in the structures
    % stats.pasa, stats.napheap, and stats.cg. Since A has a single row,
    % napheap is used instead of pproj.

    % print x 
    fprintf('\n  -------------------------- Solution ')
    fprintf('-------------------------\n')
    fprintf('    x = ') 
    disp(x)

    % print lambda 
    fprintf('\n  ------------------------- Multiplier ')
    fprintf('------------------------\n')
    fprintf('    lambda = ') 
    disp(lambda)
