% In this problem, a randomly generated point is projected onto the
% polyhedron associated with the Netlib LP test problem afiro

% The nonzeros of A are input as triples i, j, a_{ij}
A = [
 1  1    -1.000000000000000e+00
 2  1    -1.060000000000000e+00
16  1     1.000000000000000e+00
24  1     3.010000000000000e-01
 1  2     1.000000000000000e+00
15  2    -1.000000000000000e+00
 1  3     1.000000000000000e+00
22  3    -1.000000000000000e+00
 2  4     1.000000000000000e+00
26  4     1.000000000000000e+00
 5  5    -1.000000000000000e+00
 6  5    -1.060000000000000e+00
12  5     1.000000000000000e+00
25  5     3.010000000000000e-01
 5  6    -1.000000000000000e+00
 6  6    -1.060000000000000e+00
11  6     1.000000000000000e+00
25  6     3.130000000000000e-01
 5  7    -1.000000000000000e+00
 6  7    -9.600000000000000e-01
 9  7     1.000000000000000e+00
25  7     3.130000000000000e-01
 5  8    -1.000000000000000e+00
 6  8    -8.600000000000000e-01
10  8     1.000000000000000e+00
25  8     3.260000000000000e-01
12  9    -1.000000000000000e+00
21  9     2.364000000000000e+00
11 10    -1.000000000000000e+00
21 10     2.386000000000000e+00
 9 11    -1.000000000000000e+00
21 11     2.408000000000000e+00
10 12    -1.000000000000000e+00
21 12     2.429000000000000e+00
 5 13     1.000000000000000e+00
15 13     1.400000000000000e+00
 5 14     1.000000000000000e+00
23 14    -1.000000000000000e+00
 6 15     1.000000000000000e+00
27 15     1.000000000000000e+00
 7 16    -4.300000000000000e-01
 8 16    -1.000000000000000e+00
13 16     1.000000000000000e+00
22 16     1.090000000000000e-01
 8 17     1.000000000000000e+00
14 17    -1.000000000000000e+00
 8 18     1.000000000000000e+00
24 18    -1.000000000000000e+00
 8 19     1.000000000000000e+00
21 19    -1.000000000000000e+00
 7 20     1.000000000000000e+00
26 20     1.000000000000000e+00
 3 21     1.000000000000000e+00
 4 21    -4.300000000000000e-01
17 21     1.000000000000000e+00
23 21     1.090000000000000e-01
 3 22     1.000000000000000e+00
 4 22    -4.300000000000000e-01
18 22     1.000000000000000e+00
23 22     1.080000000000000e-01
 3 23     1.000000000000000e+00
 4 23    -3.900000000000000e-01
19 23     1.000000000000000e+00
23 23     1.080000000000000e-01
 3 24     1.000000000000000e+00
 4 24    -3.700000000000000e-01
20 24     1.000000000000000e+00
23 24     1.070000000000000e-01
17 25    -1.000000000000000e+00
21 25     2.191000000000000e+00
18 26    -1.000000000000000e+00
21 26     2.219000000000000e+00
19 27    -1.000000000000000e+00
21 27     2.249000000000000e+00
20 28    -1.000000000000000e+00
21 28     2.279000000000000e+00
 3 29    -1.000000000000000e+00
14 29     1.400000000000000e+00
 3 30     1.000000000000000e+00
25 30    -1.000000000000000e+00
 4 31     1.000000000000000e+00
27 31     1.000000000000000e+00
 3 32     1.000000000000000e+00
] ;
% The sparse version of A is stored in the pasadata structure
pprojdata.A = sparse (A (:, 1), A (:, 2), A (:, 3)) ;
[nrow ncol] = size (pprojdata.A) ;

% the left and right sides of the constraints bl <= A*x <= bu are specified
% lower bounds:
bl         = zeros (1, nrow) ;
bl(3)      = 44 ;
bl(9:nrow) = -inf ; % (no low bound)
pprojdata.bl = bl ;

% upper bounds:
bu = zeros (1, nrow) ;
bu(3)   = 44 ; bu(12) = 80 ; bu (13) = 500 ; bu (16) = 80 ; bu (17) = 500 ;
bu (26) = 310 ; bu (27) = 300 ;
pprojdata.bu = bu ;

% input lower bounds for x
pprojdata.lo = zeros (ncol, 1) ;
% there are no upper bounds for x, so nothing is specified for pasadata->hi

% using default setting for random number generator
rng('default') ;
% construct a random point to project onto the polyhedron
pprojdata.y = rand(ncol,1) ;

% print the statistics for the run
pprojdata.PrintStat = 1 ;

% call the solver
%x = pproj(pprojdata) ;
x = pproj (pprojdata) ;

% print the solution
fprintf('\n  -------------------------- Solution ')
fprintf('-------------------------\n')
fprintf('x =\n')
disp(x) ;
