#include "pproj.h"

/* =========================================================================
   ============================== pproj_default ============================
   ========================================================================= */
void pproj_default
(
    PPparm *Parm /* Parameter structure */
)
{
    /* relative error tol for dual function gradient*/
    Parm->grad_tol = 1.e-10 ;

    /* T => print status of run
       F => do not print status of run */
    Parm->PrintStatus = TRUE ;

    /* T => print statistics
       F => do not print statistics */
    Parm->PrintStat = FALSE ;

    /* PrintLevel = 0 (noprint), 1 (final), 2 (outside of loops),
                    3 (inside loops) */
    Parm->PrintLevel = 0 ;

    /* PrintParm = TRUE => print the parameters */
    Parm->PrintParm = FALSE ;

    /* T => return the problem data in priordata argument of ppdata */
    Parm->return_data = FALSE ;

    /* T => use data in priordata argument of ppdata */
    Parm->use_prior_data = FALSE ;

    /* T => rebuild problem after ascending dual function*/
    Parm->rebuild_prob = FALSE ;

    /* check_if_y_feas = 0 (do not check feasibility of projection point)
                       = 1 (check if y is satisfies feasibility tolerance
                            grad_tol and return if feasible)
                       = 2 (check if y satisfies feasibility tolerance
                            grad_tol and return, after running pproj_init,
                            if feasible) */
    Parm->check_if_y_feas = 1 ;

    /* T     => lower bounds for x are present
       F     => lower bounds for x not present, treat lo as -infinity */
    Parm->loExists = TRUE ;

    /* T     => upper bounds for x are present
       F     => upper bounds for x not present, treat hi as +infinity */
    Parm->hiExists = TRUE ;

    /* T => do not terminate until the matrix has been factored
       F => terminate as soon as error tolerance condition is satisfied */
    Parm->getfactor = FALSE ;

    /* debug = 0 (no debugging)
       debug = 1 (debugging outside of main loops)
       debug = 2 (debugging inside of main loops) */
    Parm->debug = 0 ;

    /* relative tolerance for reporting an error in the debugging routines */
    Parm->checktol = 1.e-5 ;

    /* check the sparse matrix format for the contraints to verify
       Ap, Ai, and Ax are consistent */
    Parm->CheckMatrix = FALSE;

    /* As explained in the comments at the start of this code, we solve
       the projection problem by optimizing a quadratic regularized version
       of the dual problem where the regularization parameters are a scalar
       sigma with a relatively small value (see below), and a vector
       shift_l. We are essentially computing the solution to the dual
       problem closest to shift_l. The integer assigned to start_guess has
       the following interpretation:

       start_guess = 0 => the initial guess for the solution of the dual
                          problem is lambda = 0 and shift_l = 0
                     1 => the user provided input argument lambda is put in
                          shift_l and the starting guess for the dual problem is
                          lambda = 0 (final dual solution is shift_l + lambda)
                          use this when the starting guess is very good
                     2 => shift_l = 0 and starting guess for the solution
                          to the dual problem is based on bound structure
                          associated with a prior run found in ppcom argument
                          of pproj
                     3 => shift_l = 0 and the starting guess for the solution
                          of the dual problem is the input argument lambda
                     4 => shift_l = 0 and the starting guess for the solution
                          of the dual problem is Work->lambda (from prior run)*/
    Parm->start_guess = 0 ;

    /* If user passes a prior PPcom structure, and permute = F,
       then it is assumed that the user is employing pproj's ordering. If
       permute = T, then the solution output is permuted to correspond to
       the user's ordering of variables. */
    Parm->permute = TRUE ;

    /* Phase1 controls the initial number of coordinate ascent iterations.
       The number of iterations is max {nrow^phase1, 5}. To skip phase1,
       set phase1 < 0 */
    Parm->phase1 = .333 ;

    /* T = use cholmod to update and downdate the linear equation
       F = solve linear equations by the ssor iterative methods */
    Parm->cholmod = TRUE ;

    /* T = perform a multilevel partition of the problem (used if cholmod = T)
           and solve using the multilevel version of the algorithm
       F = use problem as given */
    Parm->multilevel = TRUE ;

    /* 0 = use relative criterion ||grad L (lambda)||_sup / absAx_sup <=
           grad_tol where absAx_sup = max_i sum_j |a_{ij}x_j| where x achieves
           min in dual function
       1 = use absolute stopping criterion ||grad L (lambda)||_sup <= grad_tol
       2 = use relative criterion ||grad L (lambda)||_sup / (absAx_sup + ymax)
           <= grad_tol where ymax is the sup-norm of the projection point y */
    Parm->stop_condition = 0 ;

    /* In the factorization-based routines, the dual function
       that is maximized includes two parameters sigma and Asigma.
       When we compute the search direction, we put sigma + Asigma on
       the diagonal of AF*AF'. Asigma should be large enough to guard
       against a diagonal element in the LDL' factorization that is <= 0.
       Except for the factorization, Asigma is not used in the algorithm.
       sigma is a proximal parameter. The dual function contains a
       proximal term of the form 0.5*sigma*||lambda - shift||^2, where
       shift is the proximal shift. For most problems, we can take sigma
       to be really tiny and shift = 0. However, in some cases, the
       matrix AF*AF' can become very singular, and the proximal term
       is needed for the proper operation of the algorithm. In this case,
       the starting value for sigma is given by Parm->sigmaprox (a
       much larger sigma) which is then driven to zero through proximal
       updates.  If the user knows that the problem is really singular,
       then set Parm->use_prox = TRUE. If Parm->use_prox = FALSE, then the
       algorithm starts with a tiny sigma, and falls back to the
       proximal method if it detect singularity issues. The ssor
       iterative algorithm start with a relatively large proximal
       term, and then drive it to zero when solving the DASA linear
       system.  */
    Parm->sigma = ldexp (1, -90) ;

    /* By default, pproj employs a proximal method with a very tiny
       proximal parameter sigma (essentially there is no proximal iteration).
       When use_prox is TRUE, the proximal parameter is much larger. */
    Parm->use_prox = FALSE ;

    /* Upper bound on the maximum number of proximal updates. */
    Parm->nprox = 6 ;

    /* To regularize the dual function, we add the proximal term
       sigma/2 ||lambda - shift_l|| to obtain the regularized dual function
       L_R (lambda). A proximal update is performed, replacing shift_l
       by the current lambda, when
       ||grad L_R (lambda)||_1 <= proxupdate*||grad L (lambda)||_1; that is
       when proxerr <= proxupdate * errdual, perform prox update */
    Parm->proxupdate = ldexp (1, -4) ;

    /* factor by which proxsigma decays in a prox update */
    Parm->proxdecay = ldexp (1, -4) ;

    /* initial value for the prox parameter when prox is employed */
    Parm->proxsigma = ldexp (1, -20) ;

    /* To ensure that the factorization routine does not encounter a diagonal
       element <= 0, Asigma + sigma is added to the diagonal of A_F A_F' */
    Parm->Asigma = ldexp (1, -44) ;

    Parm->SSORsigma = ldexp (1, -13) ;

    /* T => the sigmas are scaled by max |a_{ij}| */
    Parm->ScaleSigma = TRUE ;

    /* If CHOLMOD aborts due to a small diagonal element, pproj will
       repeat the factorization nfact_tries times, each time
       multiplying Asigma by the factor Asigma_grow. If these attempts
       to factor the matrix all fail, then pproj terminates. */
    Parm->nfact_tries = 3 ;

    Parm->Asigma_grow = 8.0 ;

    /* Factor by which the stepsize parameter alpha grows when the Armijo
       condition in SpaRSA is not satisfied */
    Parm->armijo_grow = 4.0 ;

    /* Maximum number of times we try to satisfy the Armijo condition
       in SpaRSA */
    Parm->narmijo = 10 ;

    /* number of objective function values stored for the SpaRSA line search */
    Parm->mem = 8 ;

    /* Maximum number of SpaRSA iterations */
    Parm->nsparsa = 1000 ;

    /* The SpaRSA line search is nonmonotone. mem is the number of prior
       function values to store for computing the reference value in the
       line search */

    /* Stopping parameter for SpaRSA. Stop when there is a component of the
       gradient associated with equality constraints or bound inequality
       constraints for which |grad_i L_R| >= gamma * max_k |grad_k L_R| */
    Parm->gamma = 0.1 ;

    /* tau, beta, grad_decay, and gamma_decay are parameters that enter into
       the the definition of the undecided index set. An index j is undecided
       if sign (lambda_j) grad_j L_R <= -tau max_{k active} |grad_k L_R|^beta
       The active rows are the row in RLinkUp and RLinkDn. They correspond
       to equality constraints and active inequality constraints. Undecided
       indices are only monitored when ||current gradient|| <= grad_decay *
       ||initial gradient (after phase1)|| */
    Parm->tau = 0.1 ;
    Parm->beta = 0.5 ;
    Parm->grad_decay = 1.e-4 ;
    Parm->gamma_decay = 0.5 ;

    /* T = use CHOLMOD statistics to determine whether to perform a coordinate
           ascent iteration
       F = do not use coordinate ascent at the start of dasa */
    Parm->use_coor_ascent = TRUE ;

    /* The cost of a coordinate ascent iteration is proportional to Annz
       while the cost of an update/downdate iteration is proportional to Lnnz.
       We perform coordinate ascent iteration when Annz*coorcost <= estimate
       for the number of flops for an update */
    Parm->coorcost = 1. ;

    /* T = use ssor0 iteration
       F = do not use ssor0
       If T and CHOLMOD is used, then CHOLMOD statistics is used to decide
       whether the ssor0 iteration is worthwhile */
    Parm->use_ssor0 = TRUE ;

    /* T = use ssor1 iteration
       F = do not use ssor1
       If T and CHOLMOD is used, then CHOLMOD statistics is used to decide
       whether the ssor1 iteration is worthwhile */
    Parm->use_ssor1 = TRUE ;

    /* T = use SpaRSA iteration if appropriate
       F = do not use SpaRSA */
    Parm->use_sparsa = FALSE ;

    /* T means that the routines hotchol and phase1 are used when use_ppcom
       is T or F respectively. You must be an expert to set use_startup = F */
    Parm->use_startup = TRUE ;

    /* T means that the routines hotchol and phase1 are used when use_ppcom
       is T or F respectively. You must be an expert to set use_startup = F */
    Parm->use_startup = TRUE ;

    /* Stop ssor1 when current errprox <= ssordecay_errdual * errdual */
    Parm->ssordecay_errdual = 4.e-3 ;

    /* Stop ssor1 when current errprox <= ssordecay_errprox * initial errprox */
    Parm->ssordecay_ResidualNorm = 1.e-3 ;

    /* Prox update & Restart SSOR when errls <= ssordecay_errls * errprox */
    Parm->ssordecay_errls = 0.125 ;

    /* If the residual does not decay by the factor ssordecay_errprox1, then
       decrease SSORsigma by the factor ssordecay_SSORsigma */
    Parm->ssordecay_SSORsigma = 0.1 ;
    Parm->ssordecay_errprox1 = 0.8 ;    /* old: 0.5 */

    /* when the denominator of beta in CG decays by this factor, perform
       a proximal update and restart CG */
    Parm->ssordecay_beta = 1.e-6 ;

    /* In the ssor1 iteration, we store ssormem prior search directions
       and optimize over the space spanned by these prior search directions
       when the active constraints change. */
    Parm->ssormem = 8 ; /* must be > 1 if ssor1 is used */

    /* The cost of an ssor iteration is proportional to Annz while the cost
       of an update/downdate iteration is proportional to Lnnz. We perform
       ssor iterations when Annz*ssorcost <= estimate for the number of
       flops for an update */
    Parm->ssorcost = 8. ;

    /* Upper bound on the number of ssor iterations */
    Parm->ssormaxits = PPINFINT ;

    /* If a row has been dropped, we do not immediately rebind it, but
       allow some slack before rebinding. If other optimality violations
       are large enough, we keep the row dropped or the column free
       until there is some benefit in the error from adding the row or
       binding the column */
    Parm->cutfactor = .0001 ;

    /* If an equation is dropped, we do not immediately activate when it
       becomes active. First, we check the relative constraint violation.
       If the relative violation is small enough, then the constraint is
       kept inactive. In particular, when

       |b_i - sum_j a_{ij} x_j|/(|b_i| + sum_j |a_{ij} x_j|) <= eq_tol

       then the constraint is kept inactive. */
    Parm->eq_tol = 1.e-15 ;

    /* In the ssor iteration, we continue to ascend the dual function
       freeing variables until the residual error (err1) for the linear
       equation is small relative to the error (err) connected with free
       variables violating the bound constraints. Since the equation is
       positive definite, err1 tends to 0 as variables are freed and the
       dual function is ascended */
    Parm->tolssor = ldexp (1, -8) ; /* stop when err1 <= err*tolssor */

    /* Refactor A when
       ||b - Ax - sigma*(lamba-shift_l)||_1 >= tolrefactor*||b||_1
       The expression on the left is the norm of the residual of the
       linear system that is solved in dasa. */
    Parm->tolrefactor = .03125 ;

    /* Refactor A when
       ||b - Ax - sigma*(lamba-shift_l)||_1 >= tol_ls*absAx */
    Parm->tol_ls = 1.e-10 ;

    /* Stop execution when errdual does not improve for maxstagnate
       consecutive iterations */
    Parm->maxstagnate = 7 ;

    /* LP = TRUE => PPROJ is being used to solve an LP */
    Parm->LP = FALSE ;

    /* There are special parameters when PPROJ is used to solve an LP.
       Terminate PPROJ when dual gradient <= grad_tol*LinGrad_tol*norm_lambda */
    Parm->LinGrad_tol = 1.e-2 ;

    /* Terminate PPROJ when normalized dual gradient (primal feasibility) <=
       LinFactor times normalized dual feasibility error */
    Parm->LinFactor = 1.e-4 ;
}
