#---------------------------------------------------------------------------
# specify the compiler
#---------------------------------------------------------------------------
CC = gcc

#---------------------------------------------------------------------------
# set the optimization level
#---------------------------------------------------------------------------

# optimization level 3 and no debugging:
OPTFLAGS = -O3 -DNDEBUG

# g compiler, no optimization, lots of checks during compilation, and
# debugging checks during execution
# OPTFLAGS = -W -Wall -pedantic -Wmissing-prototypes \
	-Wredundant-decls -Wnested-externs -Wdisabled-optimization \
	-fexceptions -Wno-parentheses -Wshadow -Wcast-align \
	-Winline -Wstrict-prototypes -Wno-unknown-pragmas -g -DNSUPER

#---------------------------------------------------------------------------
# specify the BLAS, LAPACK, and LDLIBS
#---------------------------------------------------------------------------

# For openblas, something like the following may work if the openblas
# and lapack are in a directory that is checked by default
# (be sure to include gfortran and pthread):
#
#BLAS   = -lopenblas -lgfortran -lpthread
#LAPACK = -llapack
#LDLIBS =
#OPTFLAGS += -DNSUPER

# The option DNSUPER above is connected with performance issues for
# OpenBLAS when used with OpenMP threading. Intel's mkl BLAS seem to
# work correctly when used with OpenMP threading, in which case the
# supernodal routines of SuiteSparse can be utilized. To use Intel's
# mkl BLAS, something like the following may work. The initial path below
# should point to the directory where the libraries are found.

BLAS = -L/usr/lib/x86_64-linux-gnu -lmkl_intel_lp64 -lmkl_intel_thread \
	-lmkl_core -liomp5 -lpthread
LAPACK = -lmkl_lapack95_lp64

# The SuiteOPTconfig.h file contains a definition for an infinite floating
# point number based on the ANSI C99 and C90 standards. A different definition
# can be given here using OPTFLAGS. For example:

# OPTFLAGS += -DSuiteOPTinf=1e200
